<?php
/**
 *
 * Ada  payment plugin
 *
 * @author Ada
 * @version 1.1.0
 * @package VirtueMart
 * @subpackage payment
 * Copyright (C) 2019 - 2020 Virtuemart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://virtuemart.net
 */

defined('_JEXEC') or die('Restricted access');
define('ADA_VIRTUEMART_EXTENSION_VERSION', '1.1.0');

require_once('lib/Ada/AdaClient.php');

if (!class_exists('vmPSPlugin'))
    require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');

class plgVmPaymentAdapay extends vmPSPlugin
{
    private $ada;

    function __construct(&$subject, $config)
    {

        parent::__construct($subject, $config);

        $this->_loggable = true;
        $this->tableFields = array_keys($this->getTableSQLFields());
        $varsToPush = $this->getVarsToPush();

        $this->setConfigParameterable($this->_configTableFieldName, $varsToPush);
        
    }


    public function getVmPluginCreateTableSQL()
    {
        return $this->createTableSQL('Payment Ada Table');
    }

    function getTableSQLFields()
    {
        $SQLfields = array(
            'id' => 'int(1) UNSIGNED NOT NULL AUTO_INCREMENT',
            'virtuemart_order_id' => 'int(1) UNSIGNED',
            'order_number' => 'char(64)',
            'virtuemart_paymentmethod_id' => 'mediumint(1) UNSIGNED',
            'payment_name' => 'varchar(5000)',
            'payment_order_total' => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
            'payment_currency' => 'char(5)',
            'uuid'=>'varchar(5000)',
            'logo' => 'varchar(5000)'
        );


        return $SQLfields;
    }

    function getCosts(VirtueMartCart $cart, $method, $cart_prices)
    {
        return 0;
    }

    protected function checkConditions($cart, $method, $cart_prices)
    {
        return true;
    }

    function plgVmOnStoreInstallPaymentPluginTable($jplugin_id)
    {
        return $this->onStoreInstallPluginTable($jplugin_id);
    }

    public function plgVmonSelectedCalculatePricePayment(VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name)
    {
        return $this->onSelectedCalculatePrice($cart, $cart_prices, $cart_prices_name);
    }

    function plgVmgetPaymentCurrency($virtuemart_paymentmethod_id, &$paymentCurrencyId)
    {
        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id)))
            return NULL;

        if (!$this->selectedThisElement($method->payment_element))
            return false;

        $this->getPaymentCurrency($method);

        $paymentCurrencyId = $method->payment_currency;

        return;
    }

    function plgVmOnCheckAutomaticSelectedPayment(VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter)
    {
        return $this->onCheckAutomaticSelected($cart, $cart_prices, $paymentCounter);
    }

    public function plgVmOnShowOrderFEPayment($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name)
    {
        $this->onShowOrderFE($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
    }

    function plgVmonShowOrderPrintPayment($order_number, $method_id)
    {
        return $this->onShowOrderPrint($order_number, $method_id);
    }

    function plgVmDeclarePluginParamsPayment($name, $id, &$data)
    {

        return $this->declarePluginParams('payment', $name, $id, $data);
    }

    function plgVmDeclarePluginParamsPaymentVM3(&$data)
    {
       
        return $this->declarePluginParams('payment', $data);
    }

    function plgVmSetOnTablePluginParamsPayment($name, $id, &$table)
    {
        return $this->setOnTablePluginParams($name, $id, $table);
    }

    private function verifyCallbackData($post, $apiKey)
    {
        if (!isset($post['verify_hash'])) {
            return false;
        }

        $verifyHash = $post['verify_hash'];
        unset($post['verify_hash']);
        ksort($post);
        $postString = serialize($post);
        $checkKey = hash_hmac('sha1', $postString, $apiKey);
        if ($checkKey != $verifyHash) {
            return false;
        }

        return true;
    }

    function plgVmOnPaymentNotification()
    {
        try {
            $jinput = JFactory::getApplication()->input;
            $post = $jinput->getArray($_POST);

            if (!isset($post['order_number']) && !isset($post['order_id'])) {
                throw new Exception('order_number was not found in callback');
            }
            $virtuemartOrderId = isset($post['order_id']) ? $post['order_id'] : $post['order_number'];

            $modelOrder = VmModel::getModel('orders');
            $order = $modelOrder->getOrder($virtuemartOrderId);

            if (!$order)
                throw new Exception('Order #' . $post['order_number'] . ' does not exists');
            $method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id);

            if ($method && $this->verifyCallbackData($post, $method->api_key)) {
                if (!$this->selectedThisElement($method->payment_element))
                    return false;

                switch ($post['status']) {
                    case 'completed':
                        $orderStatus = $method->completed_status;
                        $orderComment = 'AdaPay invoice was paid successfully.';
                        break;
                    case 'mismatch':
                        $orderStatus = $method->overpaid_status;
                        $orderComment = 'AdaPay invoice was overpaid. ' . $post['comment'];
                        break;
                    case 'error':
                        $orderStatus = $method->invalid_status;
                        $orderComment = 'AdaPay invoice has some internal error. Please contact support for details.';
                        break;
                    case 'cancelled':
                        $orderStatus = $method->canceled_status;
                        $orderComment = 'AdaPay invoice is expired.';
                        break;
                    case 'expired':
                        if ($post['source_amount'] > 0) {
                            $orderStatus = $method->expired_status;
                            $orderComment = 'AdaPay invoice is underpaid. ' . $post['comment'];
                        } else {
                            $orderStatus = $method->canceled_status;
                            $orderComment = 'AdaPay invoice is expired.';
                        }

                        break;
                    default:
                        $orderStatus = NULL;
                        $orderComment = NULL;
                }

                if (!is_null($orderStatus)) {
                    $modelOrder = new VirtueMartModelOrders();
                    $order['order_status'] = $orderStatus;
                    $order['virtuemart_order_id'] = $virtuemartOrderId;
                    $order['customer_notified'] = 1;
                    $order['comments'] = $orderComment;
                    if (!empty($post['source_amount']) && $post['source_amount'] > 0) {
                        $order['paid'] = $post['source_amount'];
                        $order['paid_on'] = JFactory::getDate();
                    }

                    $modelOrder->updateStatusForOneOrder($virtuemartOrderId, $order, true);

                }
            }
        } catch (Exception $e) {
            exit(get_class($e) . ': ' . $e->getMessage());
        }
    }

    function plgVmOnPaymentResponseReceived(&$html)
    {

        if (!class_exists('VirtueMartCart'))
            require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');

        if (!class_exists('shopFunctionsF'))
            require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');

        if (!class_exists('VirtueMartModelOrders'))
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');

        $virtuemart_paymentmethod_id = JRequest::getInt('pm', 0);
        $order_number = JRequest::getString('order_number', 0);
        $vendorId = 0;


         

        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id)))
            return NULL;

        if (!$this->selectedThisElement($method->payment_element))
            return NULL;

        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number)))
            return NULL;

        if (!($paymentTable = $this->getDataByOrderId($virtuemart_order_id)))
            return '';


        $req = [

              'uuid' => $paymentTable->uuid,
              //'uuid'=>"851144a2-7d23-4a0a-9996-0e8378ff6e5e",

        ];


          $curl = curl_init();
          curl_setopt_array($curl, [
          CURLOPT_URL => $method->url."/payment-request/get-by-uuid",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => json_encode($req),
          // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
          CURLOPT_HTTPHEADER => [
            "Authorization: Bearer".$method->api_key,
           "Content-Type: application/json"
          ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);

        $data = json_decode($response);


        $payment_name = $method->payment_name;
        $html = $this->_getPaymentResponseHtml($paymentTable, $payment_name,$data);

        return true;
    }

    function _getPaymentResponseHtml ($paymentTable, $payment_name,$paymentresponse) {
        

        $status = $subStatus = '';
        if (isset($paymentresponse->status) && $paymentresponse->status  == VmInfo(vmText::_('VMPAYMENT_ADA_CONFIREMED_STATUS_LABEL'))) {
            $status = ucfirst($paymentresponse->status);
        }elseif (isset($paymentresponse->status) && $paymentresponse->status  == VmInfo(vmText::_('VMPAYMENT_ADA_PENDING_STATUS_LABEL'))) {
            $status = ucfirst($paymentresponse->status);
        }elseif (isset($paymentresponse->status) && $paymentresponse->status  == VmInfo(vmText::_('VMPAYMENT_ADA_CONFIREMED_STATUS_LABEL')) && isset($paymentresponse->subStatus) && $paymentresponse->subStatus  == VmInfo(vmText::_('VMPAYMENT_ADA_OVERPAID_STATUS_LABEL'))) {
            $status = ucfirst($paymentresponse->status);
            $subStatus = ucfirst($paymentresponse->subStatus);
        }else{
            $status = VmInfo(vmText::_('VMPAYMENT_ADA_DEFAULT_STATUS_DESCRIPTION'));
        }

        vmLanguage::loadJLang('com_virtuemart');

        $html = '<table>' . "\n";
        $html .= $this->getHtmlRow ('COM_VIRTUEMART_PAYMENT_NAME', $payment_name);
        $html .= $this->getHtmlRow (VmInfo(vmText::_('VMPAYMENT_ADA_PAYMENT_STATUS_LABEL')), $status);
        if (!empty($paymentTable)) {
            $html .= $this->getHtmlRow ('VMPAYMENT_ADA_ORDER_NUMBER', $paymentTable->order_number);
        }
        $html .= '</table>' . "\n";

        return $html;
    }

    public function onSelectedCalculatePrice (VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {

        $idName = $this->_idName;

        if (!($method = $this->selectedThisByMethodId ($cart->{$idName}))) {
            return NULL; // Another method was selected, do nothing
        }
        if (!$method = $this->getVmPluginMethod ($cart->{$idName}) or empty($method->{$idName})) {
            return NULL;
        }

        $cart_prices_name = '';
        $cart_prices['cost'] = 0;

        if (!$this->checkConditions ($cart, $method, $cart_prices)) {
            return FALSE;
        }

        $cart_prices_name = $this->renderPluginName ($method, $cart->automaticSelectedPayment);

        $this->setCartPrices ($cart, $cart_prices, $method);

        return TRUE;
    }

    protected function renderPluginName($plugin,$addSelect = false)
    {

       
        static $c = array();
        $idN = 'virtuemart_' . $this->_psType . 'method_id';

        if (isset($c[$this->_psType][$plugin->$idN])) {
            return $c[$this->_psType][$plugin->$idN];
        }

        $return = '';
        $plugin_name = $this->_psType . '_name';
        $plugin_desc = $this->_psType . '_desc';
        $description = '';
        $logosFieldName = $this->_psType . '_logos';
        $logos = property_exists($plugin, $logosFieldName) ? $plugin->$logosFieldName : array();
        if (!empty($logos)) {
            $return = $this->displayLogos($logos) . ' ';
        }
        if (!empty($plugin->$plugin_desc)) {
            $description = '<span class="' . $this->_type . '_description">' . $plugin->$plugin_desc . '</span>';
        }
        $c[$this->_psType][$plugin->$idN] = $return . '<span class="' . $this->_type . '_name">' . $plugin->$plugin_name . '</span>' . $description;

        return $c[$this->_psType][$plugin->$idN];
    }

    protected function getPluginHtml($plugin, $selectedPlugin, $pluginSalesPrice)
    {

        $pluginmethod_id = $this->_idName;
        $pluginName = $this->_psType . '_name';
        if ($selectedPlugin == $plugin->$pluginmethod_id) {
            $checked = 'checked="checked"';
        } else {
            $checked = '';
        }

        $html = '<input type="radio" name="' . $pluginmethod_id . '" id="' . $this->_psType . '_id_' . $plugin->$pluginmethod_id . '"   value="' . $plugin->$pluginmethod_id . '" ' . $checked . ">\n"
            . '<label for="' . $this->_psType . '_id_' . $plugin->$pluginmethod_id . '">' . '<span class="' . $this->_type . '">' . $plugin->$pluginName . "</span></label>\n";

        return $html;
    }

    function plgVmDisplayListFEPayment(VirtueMartCart $cart, $selected = 0, &$htmlIn)
    {
        $session = JFactory::getSession();
        $errors = $session->get('errorMessages', 0, 'vm');

        if ($errors != "") {
            $errors = unserialize($errors);
            $session->set('errorMessages', "", 'vm');
        } else
            $errors = array();

        return $this->displayListFE($cart, $selected, $htmlIn);
    }

    public function getGMTTimeStamp()
    {
        $tz_minutes = date('Z') / 60;

        if ($tz_minutes >= 0)
            $tz_minutes = '+' . sprintf("%03d", $tz_minutes);

        $stamp = date('YdmHis000000') . $tz_minutes;

        return $stamp;
    }

    private function get_ada_receive_currencies ($source_currency) {

        $currencies = $this->ada->getCurrencies($source_currency);
          
        return array_reduce($currencies, function ($acc, $curr) {
            $acc[$curr['cid']] = $curr;
            return $acc;
        }, []);
           
    }

    function plgVmConfirmedOrder($cart, $order)
    {
        
        if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id)))
            return NULL;

        if (!$this->selectedThisElement($method->payment_element))
            return false;

        if (!class_exists('VirtueMartModelOrders'))
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');

        if (!class_exists('VirtueMartModelCurrency'))
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');

        VmConfig::loadJLang('com_virtuemart', true);
        VmConfig::loadJLang('com_virtuemart_orders', true);

        $mainframe = JFactory::getApplication();
		$plugin = JPluginHelper::getPlugin('vmpayment', 'adapay');
        $pluginParams = new JRegistry();
        $pluginParams->loadString($plugin->params);
        $appParams = JFactory::getApplication()->getParams();

       

        //$app = Factory::getApplication(); 


        $orderID = $order['details']['BT']->virtuemart_order_id;
        $order_number= $order['details']['BT']->order_number;
        $paymentMethodID = $order['details']['BT']->virtuemart_paymentmethod_id;

        $currency_code_3 = shopFunctions::getCurrencyByID($order['details']['BT']->order_currency, 'currency_code_3');
        //$this->ada = new AdaClient($pluginParams['api_key']);
        $this->ada = new AdaClient($method->api_key,$method->url);
        // $ada_receive_currencies = $this->get_ada_receive_currencies($currency_code_3);
        // $ada_receive_cids = array_keys($ada_receive_currencies);

        $description = array();
        foreach ($order['items'] as $item) {
            $description[] = $item->product_quantity . ' × ' . $item->order_item_name;
        }


        $lang = JFactory::getLanguage();
         
    
        $total_amount = $order['details']['BT']->order_total * 1098901.098901099;

        $request = [
            'amount' => (int)$total_amount,
            'paymentRequestExpirationTime' => (int)$method->ExpirationTime, 
            'receiptEmail' => $order['details']['BT']->email,
            //'returnUrl'=>"http://localhost/ada_new/index.php?option=com_virtuemart&view=vmplg&task=PaymentResponseReceived&on=SIYC05&pm=2&Itemid=0&lang="
            'returnUrl'=>(JROUTE::_(JURI::root() . 'index.php?option=com_virtuemart&view=vmplg&task=PaymentResponseReceived&order_number='.$order_number.'&pm='.$paymentMethodID.'&Itemid=0&lang='))

        ];

    
        $invoice = $this->ada->createTransaction($request);


        //$payment_name = $this->renderPluginName($this->_currentMethod,$order);
        //$payment_name = $this->renderPluginName($method);

        //insert data in Database
        $dbValues['order_number'] = $order['details']['BT']->order_number;
        $dbValues['payment_name'] = 'Ada';
        $dbValues['virtuemart_paymentmethod_id'] = $cart->virtuemart_paymentmethod_id;
        //$dbValues['payment_currency'] = $this->_currentMethod->payment_currency;
        $dbValues['payment_order_total'] = $order['details']['BT']->order_total;
        $dbValues['uuid'] = $invoice['uuid'];
        $this->storePSPluginInternalData($dbValues);


    
        if ($invoice) {
            if ($invoice['statusCode'] == '400') {

                $html = "<h3> An error occurred while placing order! Error info: " . $invoice['message'][0].  "</h3>";
                return $this->processConfirmedOrderPaymentResponse(0, $cart, $order, $html, 'Ada', '');
                
            }else if($invoice['statusCode'] == '401'){

                $html = "<h3> Please check your ADA PAY API KEY and Url  <br><h5>" . $invoice['message'].  "</h5></h3>";
                return $this->processConfirmedOrderPaymentResponse(0, $cart, $order, $html, 'Ada', '');


            }else if ($invoice['error']) {

               $html = "<h3>" . $invoice['error'].  "</h3>";
                return $this->processConfirmedOrderPaymentResponse(0, $cart, $order, $html, 'Ada', '');

            }else if ($invoice['status'] == 'error') {

                $html = "<h3>Please check you ADA PAY API KEY and Url form an administrator Site</h3>";
                return $this->processConfirmedOrderPaymentResponse(0, $cart, $order, $html, 'Ada', '');
                
            } else {

                if ($method->sandbox == 1) {
                   
                    $cart->emptyCart();
                    //header('Location: ' . $invoice['data']['invoice_url']);
                    header( 'Location: ' . 'https://sandbox.adapay.finance/pay/'.$invoice['uuid'] );
                    exit;
                }else{

                    $cart->emptyCart();
                    //header('Location: ' . $invoice['data']['invoice_url']);
                    header( 'Location: ' . 'https://adapay.finance/pay/'.$invoice['uuid'] );
                    exit;
                    
                }
            }
        }
    }
}

defined('_JEXEC') or die('Restricted access');

if (!class_exists('VmConfig'))
    require(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_virtuemart' . DS . 'helpers' . DS . 'config.php');

if (!class_exists('ShopFunctions'))
    require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'shopfunctions.php');

defined('JPATH_BASE') or die();
