<?php
/*------------------------------------------------------------------------
# com_j2store - J2Store
# ------------------------------------------------------------------------
# author    Ramesh Elamathi - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2014 - 19 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://j2store.org
# Technical Support:  Forum - http://j2store.org/forum/index.html
-------------------------------------------------------------------------*/

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

require_once (JPATH_ADMINISTRATOR.'/components/com_j2store/library/plugins/payment.php');


class plgJ2StorePayment_adapay extends J2StorePaymentPlugin
{
	/**
	 * @var $_element  string  Should always correspond with the plugin's filename,
	 *                         forcing it to be unique
	 */
        var $_element    = 'payment_adapay';
      //var $_element    = 'Adapay';



	function __construct(& $subject, $config)
	{
		
		parent::__construct($subject, $config);
		$this->loadLanguage( 'com_j2store', JPATH_ADMINISTRATOR );
	}

	/**
	 * verify Accept Subscription payment before payment
	 * */
	function onJ2StoreAcceptSubscriptionPayment($element){
		if ($this->_isMe($element)){
			$support_subscription = $this->params->get('support_subscription', 1);
			if($support_subscription){
				return true;
			}
			return false;
		} else {
			return null;
		}
	}

	/**
	 * To process renewal payment
	 * */
	function onJ2StoreProcessRenewalPayment($paymentType, $subscription, $order){
		if($paymentType == $this->_element){
			$j2StorePlugin = J2Store::plugin();
			$j2StorePlugin->event('PendingRenewalPayment', array($subscription, $order));
		}
	}

	function onJ2StoreCalculateFees($order) {
		// is customer selected this method for payment ? If yes, apply the fees
		$payment_method = $order->get_payment_method ();

		if ($payment_method == $this->_element) {
			$total = $order->order_subtotal + $order->order_shipping + $order->order_shipping_tax;
			$surcharge = 0;
			$surcharge_percent = $this->params->get ( 'surcharge_percent', 0 );
			$surcharge_fixed = $this->params->get ( 'surcharge_fixed', 0 );
			if (( float ) $surcharge_percent > 0 || ( float ) $surcharge_fixed > 0) {
				// percentage
				if (( float ) $surcharge_percent > 0) {
					$surcharge += ($total * ( float ) $surcharge_percent) / 100;
				}

				if (( float ) $surcharge_fixed > 0) {
					$surcharge += ( float ) $surcharge_fixed;
				}

				$name = $this->params->get ( 'surcharge_name', JText::_ ( 'J2STORE_CART_SURCHARGE' ) );
				$tax_class_id = $this->params->get ( 'surcharge_tax_class_id', '' );
				$taxable = false;
				if ($tax_class_id && $tax_class_id > 0)
					$taxable = true;
				if ($surcharge > 0) {
					$order->add_fee ( $name, round ( $surcharge, 2 ), $taxable, $tax_class_id );
				}
			}
		}
	}

    /**
     * Prepares the payment form
     * and returns HTML Form to be displayed to the user
     * generally will have a message saying, 'confirm entries, then click complete order'
     *
     * @param $data     array       form post data
     * @return string   HTML to display
     */
    function _prePayment( $data )
    {
        // prepare the payment form

     //    $uri = JUri::getInstance();


        $vars = new JObject();
        $vars->order_id = $data['order_id'];
        $vars->orderpayment_id = $data['orderpayment_id'];
        $vars->orderpayment_amount = $data['orderpayment_amount'];
        $vars->orderpayment_type = $this->_element;
        $sandbox = $this->params->get('sandbox');
        $api_key = $this->params->get('api_key');
        $url = $this->params->get('url');
        $expirationtime = $this->params->get('expirationtime');


        //$vars->bank_information = $this->params->get('bank_information', '');

        $vars->display_name = $this->params->get('display_name', JText::_( "PLG_J2STORE_PAYMENT_ADAPAYMENT"));
        $vars->onbeforepayment_text = $this->params->get('onbeforepayment', '');
        $vars->button_text = $this->params->get('button_text', 'J2STORE_PLACE_ORDER');

       

        //$return_url = $uri->root() . JRoute::_("index.php?option=com_j2store&view=checkout&task=confirmPayment&orderpayment_type=" . $this->_element . "&paction=display");
		F0FTable::addIncludePath ( JPATH_ADMINISTRATOR . '/components/com_j2store/tables' );
		$order = F0FTable::getInstance ( 'Order', 'J2StoreTable' )->getClone ();
		$order->load ( array (
			'order_id' => $vars->order_id
		) );
		$vars->hash = $this->generatHash($order);
        //$html = $this->_getLayout('prepayment', $vars);
        

        //curl request
        $total_amount = $data['orderpayment_amount'] * 1098901.098901099;

        $result = [
	            'amount' => (int)$total_amount,
	            'paymentRequestExpirationTime' => (int)$expirationtime, 
	            'receiptEmail' => 'test@test.com',
	            //'returnUrl'=>"http://localhost/ada_new/index.php?option=com_virtuemart&view=vmplg&task=PaymentResponseReceived&on=SIYC05&pm=2&Itemid=0&lang="
	            'returnUrl'=> JUri::root()."index.php?option=com_j2store&view=checkout&task=confirmPayment&orderpayment_type=" . $this->_element . "&paction=display",

        ];

      
          $curl = curl_init();
	      curl_setopt_array($curl, [
	      CURLOPT_URL => $url.'/'.'payment-request',
	      CURLOPT_RETURNTRANSFER => true,
	      CURLOPT_ENCODING => "",
	      CURLOPT_MAXREDIRS => 10,
	      CURLOPT_TIMEOUT => 30,
	      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	      CURLOPT_CUSTOMREQUEST => "PUT",
	      CURLOPT_POSTFIELDS => json_encode($result),
	      // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
	      CURLOPT_HTTPHEADER => [
	        "Authorization: Bearer ".$api_key,
	       "Content-Type: application/json"
	      ],
	    ]);

	    $response = curl_exec($curl);
	    $data = json_decode($response);

	    if (isset($data)) {
	    	if (isset($data->statusCode)  && $data->statusCode  == '400') {
	    		echo "<h3> An error occurred while placing order! Error info: <br><h5>" . $data->message[0].  "</5></h3>";
	    		exit();
	    	}else if (isset($data->statusCode)  && $data->statusCode  == '401') {
	    		echo "<h3> Please check your API KEY or URL  <br><h5>" . $data->message.  "</h5></h3>";
	    		exit();
	    	}else{

    		    $vars->uuid = $data->uuid;
			    $session = JFactory::getSession();
		        $session->set('uuid',$vars->uuid);
			    $html =  $this->_getLayout('prepayment', $vars);
			    return $html;
	    	}	
	    }else{

	    	echo "<h3>Please check your ADA PAY API KEY and Url from an administrator site</h3>";
	    		exit();
	    }

     //    if ($data) {
    
     //        if ($data->statusCode  == '400') {

     //        	$html =  "<h3> An error occurred while placing order! Error info: " . $data->message[0].  "</h3>";

					// // Only print notices if not reloading the checkout, otherwise they're lost in the page reload.
					// return $html;

     //        } else {

     //        	header( 'Location: ' . 'https://sandbox.adapay.finance/pay/'.$data->uuid );
	            
     //            exit;
     //        }
     //    }

        // return $html;
    }

	/**
	 * Processes the payment form
	 * and returns HTML to be displayed to the user
	 * generally with a success/failed message
	 *
	 * @param $data     array       form post data
	 * @return string   HTML to display
	 */
	function _postPayment($data) {
		// Process the payment
	
		$vars = new JObject ();
		$url = $this->params->get('url');
		$sandbox = $this->params->get('sandbox');
		$app = JFactory::getApplication ();
		$api_key = $this->params->get('api_key');
		$session = JFactory::getSession();

		$uuid  = $session->get('uuid');
    
		//$uuid = $app->input->getString( 'uuid' );

		 $req = [

              'uuid' => $uuid,
              //'uuid'=>"851144a2-7d23-4a0a-9996-0e8378ff6e5e",

        ];

          $curl = curl_init();
          curl_setopt_array($curl, [
          CURLOPT_URL => $url.'/'.'payment-request/get-by-uuid',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => json_encode($req),
          // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
          CURLOPT_HTTPHEADER => [
            "Authorization: Bearer".$api_key,
           "Content-Type: application/json"
          ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        $data_convert = json_decode($response);

      
      
        $status = $subStatus = '';
        if (isset($data_convert->status) && $data_convert->status == 'confirmed') {
            $status = ucfirst($data_convert->status);
        }elseif (isset($data_convert->status) && $data_convert->status == 'pending') {
            $status = ucfirst($data_convert->status);
        }elseif (isset($data_convert->status) && $data_convert->status == 'confirmed' && isset($data_convert->subStatus) && $data_convert->status == 'overpaid') {
            $status = ucfirst($data_convert->status);
            $subStatus = ucfirst($data_convert->subStatus);
        }elseif(isset($data_convert->status) && $data_convert->status == 'expired'){
            $status = ucfirst($data_convert->status);
        }else{
        	if (isset($data_convert->status) && $data_convert->status== 'new') {
        
               $status = 'Your Payment not initiate yet please  go to previous tab for Payment';
        	}
        }

		$paction = $app->input->getString ( 'paction' );

		switch ($paction) {
			case 'display' :
				$vars->onafterpayment_text = JText::_ ( $status );
				$html = $this->_getLayout ( 'postpayment', $vars );
				$html .= $this->_displayArticle ();
				break;
			case 'process' :
				JSession::checkToken() or die( 'Invalid Token' );
				$result = $this->_process ($data);
				$json = json_encode ( $result );
				echo $json;
				$app->close ();
				break;
			default :
				$vars->message = JText::_ ( $this->params->get ( 'onerrorpayment', '' ) );
				$html = $this->_getLayout ( 'message', $vars );
				break;
		}

		return $html;
	}

	/**
	 * Processes the payment form
	 * and returns HTML to be displayed to the user
	 * generally with a success/failed message
	 *
	 * @param $data array
	 *        	form post data
	 * @return string HTML to display
	 */
	function _process($data) {
		// Process the payment

		$app = JFactory::getApplication ();
		$vars = new JObject ();
		$sandbox = $this->params->get('sandbox');
		$order_id = $app->input->getString( 'order_id' );
		$uuid = $app->input->getString( 'uuid' );
		
		F0FTable::addIncludePath ( JPATH_ADMINISTRATOR . '/components/com_j2store/tables' );
		$order = F0FTable::getInstance ( 'Order', 'J2StoreTable' )->getClone ();


		$json = array();
		if ($order->load ( array (
				'order_id' => $order_id
		) )) {

			if(($order->orderpayment_type != $this->_element) || !$this->validateHash($order)) {
				$json ['error'] = $this->params->get ( 'onerrorpayment', '' );
				return $json;
			}


			$bank_information = $this->params->get ( 'bank_information', '' );

			if (JString::strlen ( $bank_information ) > 5) {

				$html = '<br />';
				$html .= $bank_information;
				$array = json_decode($order->order_params,true);
				$array[$this->_element] = $html;
				$order->order_params = json_encode($array);
                if($this->params->get('enable_bank_transfer_strip_tags',0)){
                    $html = strip_tags(preg_replace('#<br\s*/?>#i', "\n",$html));
                }
				$order->customer_note = $order->customer_note . $html;
			}

			$order_state_id = $this->params->get ( 'payment_status', 4 ); // DEFAULT: PENDING
			if ($order_state_id == 1) {

				// set order to confirmed and set the payment process complete.
				$order->payment_complete ();

			} else {
				// set the chosen order status and force notify customer
				$order->update_status ( $order_state_id, true );
				// also reduce stock
				$order->reduce_order_stock ();
			}

			if ($order->store ()) {

				if ($sandbox == 1) {
					$order->empty_cart();
	                $return_url1 = 'https://sandbox.adapay.finance/pay/'.$uuid;
	                $json ['redirect'] = $return_url1;

				}else{

					$order->empty_cart();
	                $return_url1 = 'https://adapay.finance/pay/'.$uuid;
	                $json ['redirect'] = $return_url1;

				}

				//JRoute::_ ( 'index.php?option=com_j2store&view=checkout&task=confirmPayment&orderpayment_type=' . $this->_element . '&paction=display' );
			} else {
				//$html = $this->params->get ( 'onerrorpayment', '' );
				$json ['error'] = $order->getError ();
			}
		} else {
			// order not found
			$json ['error'] = $this->params->get ( 'onerrorpayment', '' );
		}
		return $json;
	}

    /**
     * Prepares variables and
     * Renders the form for collecting payment info
     *
     * @return unknown_type
     */
    function _renderForm( $data )
    {
    	$user = JFactory::getUser();
        $vars = new JObject();
        $vars->onselection_text = $this->params->get('onselection', '');
        $html = $this->_getLayout('form', $vars);
        return $html;
    }
}
